## Introduction
- Cisco Secure Email provides technologies to mitigate threats such as spam, malware, and blended attacks at the gateway.
- Features include antivirus protection and Cisco Advanced Malware Protection for both inbound and outbound email flows.

**Antivirus protect is applied after Anti-Spam**:
![[Pasted image 20250421164327.png]]
## Antivirus Protection

##### Overview
- Antivirus protection utilizes third-party engines from Sophos and McAfee.
- Engines filter malicious threats and perform actions such as dropping, cleaning, or quarantining email messages.
##### Use Case Examples
- **IT Department**: Requires email messages with protected zip attachments; infected messages are quarantined.
- **Sales Department**: Needs encrypted attachments; virus-infected messages are explicitly dropped.
- **HR Department**: Does not send attachments to Cisco Advanced Malware Protection; non-virus policy violations are quarantined.
##### Antivirus Engines
- **Sophos** and **McAfee** engines provide cross-platform antivirus protection.
- Multilayer scanning with both engines offers enhanced defense-in-depth.
##### Scanning Process
- Virus scanning follows spam scanning in the email pipeline.
- Engines apply heuristic techniques and emulation to detect new viruses and remove malicious code.

## Advanced Malware Protection (AMP)

![[Pasted image 20250421164749.png]]

##### Overview
- Protects against zero-day and targeted file-based threats in email attachments.
- Offers file reputation queries and analysis in the cloud, with retrospective notifications for disposition changes.
##### File Reputation and Analysis
- Evaluates file reputation and sends files for analysis after antivirus scanning.
- Uses Secure Endpoint and Secure Malware Analytics clouds for analyzing unknown files.
##### Workflow
- Parses attachments, checks for archives, queries file reputation, and may upload files for deeper analysis.
- Files identified as malicious or clean based on reputation service verdicts.
##### Retrospective Verdicts
- File dispositions may change over time; AMP alerts administrators about changes.
- Notifications include message details, such as subject, sender, recipient, filename, and hash.

## Configuration and Actions

##### Antivirus Settings
- Virus scanning engines must be enabled globally.
- Actions include scanning, repairing, dropping attachments, and notifying users.
##### Advanced Malware Protection
- Can be enabled for incoming and outgoing messages but typically used for incoming.
- Provides real-time protection and communication via SSL-encrypted channels.
##### Optional Actions
- Archive original message, modify message subject, add custom header, send notifications, modify recipient, send to alternate host.

## Recommendations
- Use a multilayered approach for protection against advanced email-based threats.
- Consider Secure Malware Analytics Premium subscription for enhanced capabilities and integrations.